/*
 * Decompiled with CFR 0.152.
 */
package technology.rocketjump.undermount.mapgen.model;

import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.StringBuilder;

public class BinaryGrid {
    private Array<Array<Boolean>> xArray;

    public BinaryGrid(Array<Array<Boolean>> xArray) {
        this.xArray = xArray;
    }

    public int getWidth() {
        return this.xArray.size;
    }

    public int getHeight() {
        return this.xArray.get((int)0).size;
    }

    public int getNumTrue() {
        int numTrue = 0;
        for (Array<Boolean> yArray : this.xArray) {
            for (Boolean aBoolean : yArray) {
                if (!aBoolean.booleanValue()) continue;
                ++numTrue;
            }
        }
        return numTrue;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        for (int x = 0; x < this.xArray.size; ++x) {
            Array<Boolean> yArray = this.xArray.get(x);
            for (int y = 0; y < yArray.size; ++y) {
                if (yArray.get(y).booleanValue()) {
                    builder.append("X");
                    continue;
                }
                builder.append(".");
            }
            builder.append("\n");
        }
        return builder.toString();
    }

    public void skew(float amountToSkewBy) {
        Array<Boolean> yArray;
        int x;
        int largestArraySize = 0;
        for (x = 0; x < this.xArray.size; ++x) {
            yArray = this.xArray.get(x);
            for (int tilesToSkewBy = Math.round(amountToSkewBy * ((float)x / (float)this.xArray.size)); tilesToSkewBy > 0; --tilesToSkewBy) {
                yArray.insert(0, false);
            }
            if (yArray.size <= largestArraySize) continue;
            largestArraySize = yArray.size;
        }
        for (x = 0; x < this.xArray.size; ++x) {
            yArray = this.xArray.get(x);
            while (yArray.size < largestArraySize) {
                yArray.add(false);
            }
        }
    }

    public void transpose() {
        Array rotated = new Array();
        int rotatedSize = this.xArray.get((int)0).size;
        for (int cursor = 0; cursor < rotatedSize; ++cursor) {
            rotated.add(new Array());
        }
        for (int x = 0; x < this.xArray.size; ++x) {
            Array<Boolean> currentYArray = this.xArray.get(x);
            for (int y = 0; y < currentYArray.size; ++y) {
                ((Array)rotated.get(y)).add(currentYArray.get(y));
            }
        }
        this.xArray = rotated;
    }

    public void reverseEachRow() {
        for (int x = 0; x < this.xArray.size; ++x) {
            Array<Boolean> currentYArray = this.xArray.get(x);
            Array<Boolean> reversedYArray = new Array<Boolean>(currentYArray.size);
            for (int y = currentYArray.size - 1; y >= 0; --y) {
                reversedYArray.add(currentYArray.get(y));
            }
            this.xArray.set(x, reversedYArray);
        }
    }

    public void rotate90() {
        this.transpose();
        this.reverseEachRow();
    }

    public boolean get(int x, int y) {
        Array<Boolean> yArray = this.xArray.get(x);
        if (yArray == null) {
            return false;
        }
        return yArray.get(y);
    }
}

